/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file debug.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef DEBUG_H_
#define DEBUG_H_

#include "fwk.h"

#ifdef __cplusplus
extern "C" {
#endif

#if !DEBUG_DISABLED

void debug(int level, const char* module, int line, const char* fmt, ...);
void debugx_enter(void);
void debugx(const char* fmt, ...);
void debugx_leave(void);
void assert_failed(const char* module, int line, const char* condition);

#define assert(condition) do{ if(!(condition)){ assert_failed(__MODULE__, __LINE__, #condition); } } while(0)

#else
#ifdef __DEBUG__
#undef __DEBUG__
#define __DEBUG__ 0
#endif

#define assert(condition)

#endif

#if __DEBUG__ > 0
#ifndef __MODULE__
#error "__MODULE__ must be defined"
#endif
#endif

#if __DEBUG__ >= 1
#define ERR(...) do{ debug(1, __MODULE__, __LINE__, __VA_ARGS__); }while(0)
#else
#define ERR(...)
#endif

#if __DEBUG__ >= 2
#define WARN(...) do{ debug(2, __MODULE__, __LINE__, __VA_ARGS__); }while(0)
#else
#define WARN(...)
#endif

#if __DEBUG__ >= 3
#define DBG(...) do{ debug(3, __MODULE__, __LINE__, __VA_ARGS__); }while(0)
#define DBGX_ENTER() do{ debugx_enter(); }while(0)
#define DBGX(...) do{ debugx(__VA_ARGS__); }while(0)
#define DBGX_LEAVE() do{ debugx_leave(); }while(0)
#define DBG_BLOCK(x) x
#else
#define DBG(...)
#define DBGX_ENTER()
#define DBGX(...)
#define DBGX_LEAVE()
#define DBG_BLOCK(x)
#endif

#if __DEBUG__ >= 4
#define VERB(...) do{ debug(4, __MODULE__, __LINE__, __VA_ARGS__); }while(0)
#else
#define VERB(...)
#endif

#ifdef __cplusplus
}
#endif

#endif

