/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_sha1.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef CRYPTO_SHA1_H_
#define CRYPTO_SHA1_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

#define SHA1_SIZE 20 //160 bits
#define SHA1_BLOCK_SIZE 64

typedef struct __crypto_sha1
{
  uint64_t length;
  uint32_t state[5], curlen;
  uint8_t buf[64];
} crypto_sha1_t;

void crypto_sha1_init(crypto_sha1_t* hash);
void crypto_sha1_update(crypto_sha1_t* hash, const uint8_t* data, size_t size);
void crypto_sha1_end(crypto_sha1_t* hash, uint8_t* out);

void crypto_sha1_copy(crypto_sha1_t* hashTo, crypto_sha1_t* hashFrom);

#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_SHA1_H_ */
