/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file crypto_arc4.h
 * \copyright Copyright (c) AppNearMe Ltd 2014
 * \author Donatien Garnier
 */

#ifndef CRYPTO_ARC4_H_
#define CRYPTO_ARC4_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef struct __crypto_arc4
{
  int i;
  int j;
  uint8_t state[256];
} crypto_arc4_t;

void crypto_arc4_init(crypto_arc4_t* arc4, const uint8_t* key, size_t key_size);

void crypto_arc4_encrypt(crypto_arc4_t* arc4, const uint8_t* plaintext, uint8_t* ciphertext, size_t length);
#define crypto_arc4_decrypt(arc4, ciphertext, plaintext, length) crypto_arc4_encrypt(arc4, ciphertext, plaintext, length)

void crypto_arc4_process(crypto_arc4_t* arc4, buffer_t* buffer);



#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_ARC4_H_ */
