/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file fwk.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 * \details Standard include and defines
 */

#ifndef FWK_H_
#define FWK_H_

//Standard types definition
#include "stdint.h"
#include "stdbool.h"
#include "stddef.h"

#include "string.h"

//NULL pointer definition
#ifndef NULL
#define NULL ((void*)0)
#endif

//Debugging
#include "debug.h"

//Buffer
#include "buffer.h"
#include "buffer_network.h"

//RTOS
//#include "rtos.h" -- not for mbed
//Must be defined by impl
struct rtos_mtx_struct;
struct rtos_sem_struct;

//Typedefs
typedef struct rtos_mtx_struct rtos_mtx_t;
typedef struct rtos_sem_struct rtos_sem_t;

//Semaphores
rtos_sem_t* rtos_sem_create(int max, int count);
bool rtos_sem_get(rtos_sem_t* pSem, int timeout);
void rtos_sem_give(rtos_sem_t* pSem/*, int timeout*/); //Saturated

//Mutexes
rtos_mtx_t* rtos_mtx_create(void);
void rtos_mtx_lock(rtos_mtx_t* pMtx);
void rtos_mtx_unlock(rtos_mtx_t* pMtx);



//Macros
#define MAX(a,b) (((a)>(b))?(a):(b))
#define MIN(a,b) (((a)<(b))?(a):(b))

//Pack
#ifdef __GNUC__
#define PACKED __attribute__ ((packed))
#else
#define PACKED
#endif

#endif /* FWK_H_ */
