/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//*
  debug.c
 * Copyright (c) AppNearMe Ltd 2013
 * Author: Donatien Garnier
 */

#include "fwk.h"

#if !DEBUG_DISABLED

#ifdef __cplusplus
extern "C"
{
#endif

#include "debug.h"

#include "stdio.h"
#include "stdarg.h"

void debug(int level, const char* module, int line, const char* fmt, ...)
{
  va_list argp;

  //TODO add a mutex system at some point here
  switch(level)
  {
  default:
  case 1:
    printf("[ERROR]");
    break;
  case 2:
    printf("[WARN]");
    break;
  case 3:
    printf("[DBG]");
    break;
  case 4:
    printf("[VERB]");
    break;
  }

  printf(" Module %s - Line %d: ", module, line);

  va_start(argp, fmt);
  vprintf(fmt, argp);
  va_end(argp);

  printf("\r\n");
}

void debugx_enter(void)
{

}

void debugx(const char* fmt, ...)
{
  va_list argp;

  va_start(argp, fmt);
  vprintf(fmt, argp);
  va_end(argp);
}

void debugx_leave(void)
{
  printf("\r\n");
}

void assert_failed(const char* module, int line, const char* condition)
{
  printf("[ASSERT FAILED] Module %s - Line %d: %s\r\n", module, line, condition);
}

#ifdef __cplusplus
}
#endif

#endif

