/*
MiniTLS - A super trimmed down TLS/SSL Library for embedded devices
Author: Donatien Garnier
Copyright (C) 2013-2014 AppNearMe Ltd

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*//**
 * \file buffer.h
 * \copyright Copyright (c) AppNearMe Ltd 2013
 * \author Donatien Garnier
 */

#ifndef BUFFER_H_
#define BUFFER_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

typedef struct __buffer
{
  uint8_t* bufdata;
  size_t size;

  uint8_t* start;
  size_t first_byte_length; //In bits

  uint8_t* end;
  size_t last_byte_length; //In bits

  struct __buffer* next;

} buffer_t;

void buffer_init(buffer_t* pBuf, uint8_t* bufdata, size_t size);

void buffer_byref(buffer_t* pBuf, uint8_t* bufdata, size_t length); //New buffer by ref on a size_t array, no malloc (useful on PIC for instance)

buffer_t* buffer_new(size_t size); //malloc

uint8_t* buffer_data(buffer_t* pBuf);

void buffer_reset(buffer_t* pBuf);

size_t buffer_size(buffer_t* pBuf);

size_t buffer_length(buffer_t* pBuf);

size_t buffer_space(buffer_t* pBuf);

bool buffer_empty(buffer_t* pBuf);

void buffer_set_length(buffer_t* pBuf, size_t length);

size_t buffer_last_byte_length(buffer_t* pBuf);

void buffer_set_last_byte_length(buffer_t* pBuf, size_t length);

size_t buffer_bits_count(buffer_t* pBuf);

void buffer_write_byte(buffer_t* pBuf, uint8_t b);

void buffer_write_bit(buffer_t* pBuf, uint8_t b);

#if 0
size_t buffer_read_byte(buffer_t* pBuf, uint8_t b);

size_t buffer_read_bit(buffer_t* pBuf, uint8_t b);
#endif

buffer_t* buffer_next(buffer_t* pBuf);

void buffer_set_next(buffer_t* pBuf, buffer_t* pNextBuf);

void buffer_append(buffer_t* pBuf, buffer_t* pAppBuf);

void buffer_unlink(buffer_t* pBuf, buffer_t* pLinkedBuf);

size_t buffer_total_size(buffer_t* pBuf);

size_t buffer_total_length(buffer_t* pBuf);

void buffer_set_total_length(buffer_t* pBuf, size_t length);

void buffer_free(buffer_t* pBuf);

//Debug
void buffer_dump(buffer_t* pBuf);

#ifdef __cplusplus
}
#endif

#endif /* BUFFER_H_ */
