#include "mbed.h"
#include "AsyncSerial.hpp"
#include "TextLCD.h"
#include "string.h"

DigitalOut rudLevel1(p5);
DigitalOut rudLevel2(p6);
DigitalOut rudLevel3(p7);
DigitalOut rudLevel4(p8);
DigitalOut rudLevel5(p11);
DigitalOut rudLevel6(p12);
DigitalOut rudLevel7(p15);

DigitalOut eleLevel1(p21);
DigitalOut eleLevel2(p22);
DigitalOut eleLevel3(p23);
DigitalOut eleLevel4(p24);
DigitalOut eleLevel5(p25);
DigitalOut eleLevel6(p26);
DigitalOut eleLevel7(p29);

DigitalOut beep1(LED1);
DigitalOut beep2(LED2);
DigitalOut beep3(LED3);
DigitalOut beep4(LED4);

DigitalOut beep(p30);

Serial pc(USBTX, USBRX);
AsyncSerial Serial1(p13,p14,9600,256); // tx, rx //rot(out),master(in)
//AsyncSerial Serial2(p9,p10,9600,256);//height(out)
I2C display(p28, p27);// sda, scl
const int addr = 0x4E;// define the I2C Address
TextLCD_I2C lcd(&display,addr,TextLCD::LCD20x4);


//AsyncSerial Serial3(p28,p27,9600,256);//speed(out)
//Ticker flipper;
//Ticker flipper2;
//5-30
//5-8,11,12,13-26,29,30->total:20 free pins
//5-8,11,12,15:RUD
//21-26,29:ELE

/*
struct DATA1{
    float height;
    int rot_count;
    float air_speed;
    float analog[2];//0=ELE 1=RUD
};
DATA1 receive;
*/

//float receive[5];

struct DATA{
    float height;
    int rot_count;
    float air_speed;
    float analog[2];//0=ELE 1=RUD
};
DATA data;

struct DATA2{
    float height;
    int rot_count;
    float air_speed;
    float ele;
    float rud;
    };
    
DATA2 receive;
char a[40];
char *c;
char mheight[6], mrot[4], mspeed[6], mele[9], mrud[9];

Timer t;
//unsigned long time;
int beepTimes;

void ini(){
    /*
    int n;//count
    
    for(n=0 ; n<5 ; n++){
        receive[n] = 0.0;
        }
        */
    
    data.height=0;
    data.rot_count=0;
    data.air_speed=0;
    data.analog[0]=0.0;
    data.analog[1]=0.0;
        
    receive.height = 0.0;
    receive.rot_count = 0;
    receive.air_speed = 0.0;
    receive.ele = 0.0;
    receive.rud = 0.0;
}
//receive data => Serial2.printf("%5.2,%3d,%5.2f,%7f,%7f",(float)data.height/1000,data.rot_count,data.air_speed,data.a,data.b,data.fmps,data.angle[0],data.analog[0],data.analog[1]);
void dispini(){
        lcd.setBacklight(TextLCD::LightOn);
        
        lcd.locate(0,0);
        lcd.printf("Windnauts2019");
        
        eleLevel1 = 1;rudLevel1 = 1;
        wait_ms(100);
        eleLevel2 = 1;rudLevel2 = 1;
        wait_ms(100);
        eleLevel3 = 1;rudLevel3 = 1;
        wait_ms(100);
        eleLevel4 = 1;rudLevel4 = 1;
        wait_ms(100);
        eleLevel5 = 1;rudLevel5 = 1;
        wait_ms(100);
        eleLevel6 = 1;rudLevel6 = 1;
        wait_ms(100);
        eleLevel7 = 1;rudLevel7 = 1;
        
        
    
        lcd.locate(0,1);
        lcd.printf("Hal Startup...");
    
        
        wait_ms(500);
        eleLevel1 = 0;rudLevel1 = 0;
        wait_ms(100);
        eleLevel2 = 0;rudLevel2 = 0;
        wait_ms(100);
        eleLevel3 = 0;rudLevel3 = 0;
        wait_ms(100);
        eleLevel4 = 0;rudLevel4 = 0;
        wait_ms(100);
        eleLevel5 = 0;rudLevel5 = 0;
        wait_ms(100);
        eleLevel6 = 0;rudLevel6 = 0;
        wait_ms(100);
        eleLevel7 = 0;rudLevel7 = 0;
        lcd.locate(0,2);
        lcd.printf("Stand-by OK");
        wait_ms(500);
                
        eleLevel1 = 0;eleLevel2 = 0;eleLevel3 = 0;eleLevel4 = 0;eleLevel5 = 0;eleLevel6 = 0;eleLevel7 = 0;
        rudLevel1 = 0;rudLevel2 = 0;rudLevel3 = 0;rudLevel4 = 0;rudLevel5 = 0;rudLevel6 = 0;rudLevel7 = 0;
        wait_ms(100);
        
        t.start();
    }
    
 /*   
void displayPrint(){
    }  
    
    */  
    
void ELE(){
    
    if(0.78<=receive.ele){
        eleLevel1 = 1;
        eleLevel2 = 0;
        eleLevel3 = 0;
        eleLevel4 = 1;
        eleLevel5 = 0;
        eleLevel6 = 0;
        eleLevel7 = 0;
        }
    if(0.75<=receive.ele && receive.ele<0.78){
        eleLevel1 = 0;
        eleLevel2 = 1;
        eleLevel3 = 0;
        eleLevel4 = 1;
        eleLevel5 = 0;
        eleLevel6 = 0;
        eleLevel7 = 0;
        }
    if(0.73<=receive.ele && receive.ele<0.75){
        eleLevel1 = 0;
        eleLevel2 = 0;
        eleLevel3 = 1;
        eleLevel4 = 1;
        eleLevel5 = 0;
        eleLevel6 = 0;
        eleLevel7 = 0;
        }
    if(0.67<=receive.ele && receive.ele<0.73){
        eleLevel1 = 0;
        eleLevel2 = 0;
        eleLevel3 = 0;
        eleLevel4 = 1;
        eleLevel5 = 0;
        eleLevel6 = 0;
        eleLevel7 = 0;
        }
    if(0.65<=receive.ele && receive.ele<0.67){
        eleLevel1 = 0;
        eleLevel2 = 0;
        eleLevel3 = 0;
        eleLevel4 = 1;
        eleLevel5 = 1;
        eleLevel6 = 0;
        eleLevel7 = 0;
        }
    if(0.63<=receive.ele && receive.ele<0.65){
        eleLevel1 = 0;
        eleLevel2 = 0;
        eleLevel3 = 0;
        eleLevel4 = 1;
        eleLevel5 = 0;
        eleLevel6 = 1;
        eleLevel7 = 0;
        }
    if(receive.ele<=0.63){
        eleLevel1 = 0;
        eleLevel2 = 0;
        eleLevel3 = 0;
        eleLevel4 = 1;
        eleLevel5 = 0;
        eleLevel6 = 0;
        eleLevel7 = 1;
        }                                
    }
    
void RUD(){
    
    if(0.54<=receive.rud){
        rudLevel1 = 1;
        rudLevel2 = 0;
        rudLevel3 = 0;
        rudLevel4 = 1;
        rudLevel5 = 0;
        rudLevel6 = 0;
        rudLevel7 = 0;
        }
    if(0.52<=receive.rud && receive.rud<0.54){
        rudLevel1 = 0;
        rudLevel2 = 1;
        rudLevel3 = 0;
        rudLevel4 = 1;
        rudLevel5 = 0;
        rudLevel6 = 0;
        rudLevel7 = 0;        
        }
    if(0.49<=receive.rud && receive.rud<0.52){
        rudLevel1 = 0;
        rudLevel2 = 0;
        rudLevel3 = 1;
        rudLevel4 = 1;
        rudLevel5 = 0;
        rudLevel6 = 0;
        rudLevel7 = 0;
        }
    if(0.43<=receive.rud && receive.rud<0.49){
        rudLevel1 = 0;
        rudLevel2 = 0;
        rudLevel3 = 0;
        rudLevel4 = 1;
        rudLevel5 = 0;
        rudLevel6 = 0;
        rudLevel7 = 0;
        }
    if(0.40<=receive.rud && receive.rud<0.43){
        rudLevel1 = 0;
        rudLevel2 = 0;
        rudLevel3 = 0;
        rudLevel4 = 1;
        rudLevel5 = 1;
        rudLevel6 = 0;
        rudLevel7 = 0;
        }
    if(0.38<=receive.rud && receive.rud<0.40){
        rudLevel1 = 0;
        rudLevel2 = 0;
        rudLevel3 = 0;
        rudLevel4 = 1;
        rudLevel5 = 0;
        rudLevel6 = 1;
        rudLevel7 = 0;
        }
    if(receive.rud<0.38){
        rudLevel1 = 0;
        rudLevel2 = 0;
        rudLevel3 = 0;
        rudLevel4 = 1;
        rudLevel5 = 0;
        rudLevel6 = 0;
        rudLevel7 = 1;
        }                            
    }
    
    
void send(){   
        //pc.printf("%f,%f,%f,%f,%f\r\n",receive.height,receive.rot_count,receive.air_speed,receive.ele,receive.rud);
       //display.write(addr, receive, 7, true);

    //lcd.locate(0,0);
    //lcd.printf("abyabya");
    
    lcd.locate(0,0);
    lcd.printf("height:%5.2fm", receive.height);
    
    lcd.locate(0,1);
    lcd.printf("cadence: %3drpm", receive.rot_count/10);
    
    lcd.locate(0,2);
    lcd.printf("speed: %5.2fm/s", receive.air_speed);
    
    
    pc.printf("receive height:%5.2f,rot:%3d,speed:%5.2f,ele:%7f,rud:%7f\r\n",receive.height,receive.rot_count,receive.air_speed,receive.ele,receive.rud);
    pc.printf("divided to mheight:%s,mrot:%s,mspeed:%s,mele:%s,mrud:%s\r\n",mheight,mrot,mspeed,mele,mrud);
    pc.printf("rawReceive %s\n\n",a);
    //pc.printf("%s\r\n",c);
    //pc.printf(Serial1.getc());
    //pc.printf("root2 %c,%c,%c,%c,%c\r\n",a[0],a[1],a[2],a[3],a[4]);
    //pc.printf("%c",);
    }

    
int main(){
    int i=0;//count

    
    ini();
    dispini();
    
    while(1){
            
        //receive-> Serial2.printf("%5.2f,%3d,%5.2f,%7f,%7f\r\n",(float)data.height/1000,data.rot_count,data.air_speed,data.analog[0],data.analog[1]);
            while (Serial1.readable() > 0){
                a[i] = Serial1.getc();
               // c[i] = Serial1.getc();

                if(a[i]=='\n'){
 /*                   
                    if(receiveCount == 0){
                        a[i]='\0';
                        receive.height=atof(a);
                        receiveCount++;}
                    if(receiveCount == 1){
                        a[i]='\0';
                        receive.rot_count = atoi(a);
                        receiveCount++;}
                    if(receiveCount == 2){
                        a[i]='\0';
                        receive.air_speed = atof(a);
                        receiveCount++;}
                    if(receiveCount == 3){
                        a[i]='\0';
                        receive.ele = atof(a);
                        receiveCount++;}
                    if(receiveCount == 4){
                        a[i]='\0';
                        receive.rud = atof(a);
                        receiveCount = 0;} 
*/                 
                for(i=0 ; i<5 ; i++)
                    mheight[i] = a[i];
                mheight[5] = '0';
                                  
                for(i=6 ; i<9 ; i++)
                    mrot[i-6] = a[i];
                mrot[3] = '0';

                for(i=10 ; i<15 ; i++)
                    mspeed[i-10] = a[i];
                mspeed[5] = '0';
                
                for(i=16 ; i<24 ; i++)
                    mele[i-16] = a[i];
                mele[8] = '0';
                
                for(i=25 ; i<33 ; i++)
                    mrud[i-25] = a[i];
                mrud[8] = '0';
            
            i = 0;
            receive.height = atof(mheight); 
            receive.rot_count = atof(mrot);
            receive.air_speed = atof(mspeed);
            receive.ele = atof(mele);
            receive.rud = atof(mrud);
            
                            
            
            }else{
                i++;
            }
            

 /*               receive.height = data.height;
                receive.rot_count = (float)data.rot_count;
                receive.air_speed = data.air_speed;
                receive.ele = data.analog[0];
                receive.rud = data.analog[1];*/
             }
          
        
        //lcd.locate(0,0);
        //lcd.printf("hi");
            RUD();
            ELE();
            send();
            wait_ms(1000);

            unsigned long time=t.read_ms()/1000;
            
            if (time%300==0){
                for(beepTimes=0 ; beepTimes<4 ; beepTimes++){
                    beep = 1;
                    beep1 = 1;
                    beep2 = 1;
                    beep3 = 1;
                    beep4 = 1;
                    wait_ms(1000);
                    beep = 0;
                    beep1 = 0;
                    beep2 = 0;
                    beep3 = 0;
                    beep4 = 0;
                    }};
    }
}

