/*  
 Version 7 – Mike edit 
*/  

#include "mbed.h"  

//Motor PWM (speed)  
PwmOut PWMA(PA_8);  
PwmOut PWMB(PB_4);  

//Motor Direction  
DigitalOut DIRA(PA_9);  
DigitalOut DIRB(PB_10); 

//On board switch  
DigitalIn SW1(USER_BUTTON);    

//Use the serial object so we can use higher speeds  
Serial terminal(USBTX, USBRX);  

//Timer used for measuring speeds  
Timer timer;                                                                            

//Enumerated types  
enum DIRECTION   {FORWARD=0, REVERSE};  
enum PULSE       {NOPULSE=0, PULSE};  
enum SWITCHSTATE {PRESSED=0, RELEASED};  

//Debug GPIO  
DigitalOut probe(D10);  

//Duty cycles  
float dutyA = 1.0f; //100%  
float dutyB = 1.0f; //100%  

int main()  
{  
    //Configure the terminal to high speed  
    terminal.baud(115200); 
    
    //Set initial motor direction  
    DIRA = FORWARD;  
    DIRB = FORWARD;  
    
    //Set motor period to 100Hz  
    PWMA.period_ms(10);  
    PWMB.period_ms(10);  
    
    //Set initial motor speed to stop  
    PWMA.write(0.0f);           //0% duty cycle  
    PWMB.write(0.0f);           //0% duty cycle  
    
    //Wait for USER button (blue pull-down switch) to start  
    terminal.puts("Press USER button to start");  
    while (SW1 == RELEASED);
    
    //Set initial motor speed to stop    {  
    for(float ramp = 0.0f; ramp <= 1.0f ; ramp += 0.2)  
        {  
            PWMA.write(ramp);          //Set duty cycle y  
            PWMB.write(ramp);          //Set duty cycle y  
            wait(1);  
        }  
        
    PWMA.write(dutyA);          //Set duty cycle y  
    PWMB.write(dutyB);          //Set duty cycle y 
    wait(1.1);
    PWMB.write(0.2f);          //turn 31deg 
    wait(1.3);  
    PWMA.write(dutyA);          //Set duty cycle hyp  
    PWMB.write(dutyB);          //Set duty cycle hyp  
    wait(4.4);  
    PWMB.write(0.2f);          //turn 59deg 
    wait(1.1);  
    PWMA.write(dutyA);          //Set duty cycle x  
    PWMB.write(dutyB);          //Set duty cycle x  
    wait(2.4);  
    PWMB.write(0.2f);          //turn 90deg 
    wait(0.7);  
    
    PWMA.write(0.0f);    
    PWMB.write(0.0f);
}  