/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

//****** Cup and Ball game ******
//the object of the game is to catch the ball in the cup.
//the cup is at the bottom of the screen and the ball appears
//at the top of the screen. The player has three lives before
//the game will end dslpaying the score.

#include "MicroBit.h"

MicroBit uBit;

int ball_x = 0;
int ball_y = 0;
int loop = 0;
int before_x = 0;
int now_x = 0;
int cup_x = 0;
int score = 0;
int lives = 3;
int falling_speed = 500;

const int cup_y = 4;

bool game_running = true;
bool pause = false;

// show your smiley face on the screen...
MicroBitImage smiley("0,0,0,0, 0\n0,255,0,255,0\n0,0,0,0,0\n255,0,0,0,255\n0,255,255,255,0\n");

// show your sad face on the screen...
MicroBitImage sad("0,0,0,0, 0\n0,255,0,255,0\n0,0,0,0,0\n0,255,255,255,0\n255,0,0,0,255\n");


void onButtonA(MicroBitEvent e)
{
    if(pause == false)
    {
        if(cup_x > 0)
        {
            uBit.display.image.setPixelValue(cup_x,cup_y,0);
            cup_x = cup_x - 1; 
            uBit.display.image.setPixelValue(cup_x,cup_y,255);
        }
    }
}

void onButtonB(MicroBitEvent e)
{
    if(pause == false)
    {
        if(cup_x < 4)
        {
            uBit.display.image.setPixelValue(cup_x,cup_y,0);
            cup_x = cup_x + 1; 
        uBit.display.image.setPixelValue(cup_x,cup_y,255);
        }
    }
}

void ball_catch()
{
    //disable the buttons
    pause = true;
    
    score = score + 1;
    uBit.display.clear();
    
    for (int y=4; y >= 0; y--)
    {
        uBit.display.image.paste(smiley,0,y);
        uBit.sleep(100);
    }
    
    uBit.sleep(1000);
    uBit.display.scroll(score);
    uBit.sleep(1000);
    uBit.display.clear();
    
    //increase the speed of the ball by subtracting each time
    falling_speed = (falling_speed - 30);
    
    //enable the buttons
    pause = false;
}

void ball_missed()
{
    uBit.display.clear();
    lives = lives - 1;
    
    if(lives == 0)
    {
        game_running = false;
        uBit.display.clear();
        uBit.display.scroll("GAME OVER! SCORE:");
        uBit.display.scroll(score);
    }
    else
    {    
        for (int y=4; y >= 0; y--)
        {
            uBit.display.image.paste(sad,0,y);
            uBit.sleep(100);
        }
        uBit.sleep(1000);
        uBit.display.clear();
    }
}

void welcome()
{
    uBit.display.scroll("Ball Catch");
}

int main()
{
    //display the welcome message
    welcome();
    
    // Initialise the micro:bit runtime.
    uBit.init();
    
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_DOWN, onButtonA);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_BUTTON_EVT_DOWN, onButtonB);

    while(game_running)
    {
                
        //get random starting point for ball to drop from        
        do
        {now_x = uBit.random(5);
        }while (now_x == before_x);
        
        before_x = now_x;
        ball_x = now_x;
        ball_y = 0;
        
        
        //get random starting point for cup at bottom screen
        //cup_x = uBit.random(5);
        do
        {cup_x = uBit.random(5);
        }while (cup_x == ball_x);
        //check to make sure the starting point of the ball is not the same os the cup
        //otherwise it would score a point even if not buttones were pressed
                
        
        //display the cup on the screen at the bottom at a random location
        uBit.display.image.setPixelValue(cup_x,cup_y,255);
        
        //wait a small amount of time after showing the cup
        //and before showing the ball at the top of the screen
        uBit.sleep(100);
        
        //game loop
        for ( loop = 0; loop < 5; loop++ ) {
            uBit.display.image.setPixelValue(ball_x,ball_y,255);
            uBit.sleep(falling_speed);
            uBit.display.image.setPixelValue(ball_x,ball_y,0);
            ball_y = ball_y + 1;
            
            if(ball_y == 5)
            {  
                //check to see if the cup has caught the ball
                if((ball_x == cup_x) and ((ball_y - 1) == cup_y))
                {
                    ball_catch();
                }
                else
                {
                    ball_missed();
                }   
            }                
        }
        
        uBit.sleep(100);               
    }

while(true)
{
    uBit.display.scroll("Press Reset To Start New Game");
    uBit.sleep(1000);
}




}

