#ifndef CRC16_H_
#define CRC16_H_

/* General Layout Design taken from Erik van Wijk's crc8 library found at
http://mbed.org/users/evwijk/code/crc8/
*/
 
/* Takes in a character array with a given number of bytes. Returns the
16 bit CRC tag as a 32 bit integer. numberOfBytes exceeds 16, function returns 0.
*/ 

int     crc16 (char* dataIn, int numberOfBytes);

/* Takes in a character array with at least (numberOfBytes + 2) entries. A 16-bit
CRC tag is created from the first numberOfBytes elements of dataIn. The 16-bit tag is then
broken into two 8 bit tags. The most significant is stored in dataIn at (numberOfBytes+1) 
and the least significant is stored in dataIn at (numberOfBytes+2)

*******************************************************************************
Note: numberOfBytes indicates the number of data elements to generate the CRC.
dataIn must be at least of length numberOfBytes + 2 for the two bytes of CRC
*******************************************************************************
*/

void    crc16_attach (char* dataIn, int numberOfBytes);

/* Takes in a character array of length (numberOfBytes + 2). A 16-bit CRC is created from the first
numberOfBytes elements of dataIn. The elements at numberOfBytes + 1 and numberOfBytes + 2 are assumed
to be a CRC tag created in the form described above and are reassembled into a single integer.

The calculated CRC and the input CRC are compared

If they match, funtion is true.
If the two CRC tags to not match, function is false.

*******************************************************************************
Note: numberOfBytes indicates the number of data elements to generate the CRC.
dataIn must be at least of length numberOfBytes + 2 for the two bytes of CRC
*******************************************************************************
*/
bool    crc16_match (char* dataIn, int numberOfBytes);

 
#endif