#include "crc16.h"

/*
CRC16 generation algorithm taken from J.G. Harston at
http://mdfs.net/Info/Comp/Comms/CRC16.htm
*/

// Refer to crc16.h for overall function details

#define poly 0x11021 // Define polynomial generating CRC tag

int     crc16 (char* dataIn, int numberOfBytes) {
    if (numberOfBytes > 16)     // Keep numberOfBytes under 16
        return 0;
    int i, j;
    int crc = 0;                // Initialize CRC to zero
    
    for (j = numberOfBytes ; j > 0; j--) {  // Execute numberOfBytes times
        crc = crc ^ (*dataIn++ << 8);   // Get byte and XOR with crc
        for (i = 0; i < 8; i++) {
            crc = crc << 1;             // Rotate
            if (crc & 0x10000)          // If bit 15 is set
                crc ^= poly;            // XOR with polynomial            
        }
    }
    return crc;             // Return CRC tag       
}

void    crc16_attach (char* dataIn, int numberOfBytes) {
    int crc = crc16(dataIn, numberOfBytes);             // Generate CRC tag from first numberOfBytes elements of DataIn
    dataIn[numberOfBytes] = ((crc >> 8) & 0xFF);        // Store 8 MSbits as the next element in dataIn
    dataIn[numberOfBytes + 1] = (crc & 0xFF);           // Store the 8 LSbits is the last element in dataIn
}

bool    crc16_match (char* dataIn, int numberOfBytes) {
    int crcData = crc16(dataIn, numberOfBytes);         // Generate CRC tag from the first numberOfBytes elements of dataIn
    int a,b;
    a = dataIn[numberOfBytes];                          // Extract the last two 8 bit elements of dataIn as integers
    b = dataIn[numberOfBytes + 1];
    int crcExpect = (a << 8) + b;                       // Recombine into a single 16 bit element
    if (crcData == crcExpect)                           // Compare the generated with the expected
        return true;                                    // If they match, data is intact
    else
        return false;                                   // Otherwise, data is not intact
}            
