//-------------------------------------------------------------------
//  Hanning 窓による窓掛け
//      ゼロ詰め（zero-padding）の機能を持つ
//
//  2021/11/10, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------------------

#ifndef HANNING_WINDOW_HPP
#define HANNING_WINDOW_HPP

#include "WindowBase.hpp"

namespace Mikami
{
    class HanningWindow : public WindowBase
    {
    public:
        // コンストラクタ
        HanningWindow(uint16_t nFft, uint16_t nData)
            : WindowBase(nFft, nData) { Generate(nData); }
        explicit HanningWindow(uint16_t nFft)
            : WindowBase(nFft, nFft) { Generate(nFft); }

    private:
        // 窓関数を生成
        virtual void Generate(uint16_t nData)
        {
            for (int k=0; k<nData; k++)
                Set(k, 0.5f - 0.5f*cosf(k*PI2L_));
        }

        // コピー･コンストラクタおよび代入演算子の禁止のため
        HanningWindow(const HanningWindow& );
        HanningWindow& operator=(const HanningWindow& );
    };
}
#endif  // HANNING_WINDOW_HPP