//-------------------------------------------------------------------
//  Hamming 窓による窓掛け
//      ゼロ詰め（zero-padding）の機能を持つ
//
//  2021/11/10, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------------------

#ifndef HAMMING_WINDOW_HPP
#define HAMMING_WINDOW_HPP

#include "WindowBase.hpp"

namespace Mikami
{
    class HammingWindow : public WindowBase
    {
    public:
        // コンストラクタ
        HammingWindow(uint16_t nFft, uint16_t nData)
            : WindowBase(nFft, nData) { Generate(nData); }
        explicit HammingWindow(uint16_t nFft)
            : WindowBase(nFft, nFft) { Generate(nFft); }

    private:
        // 窓関数を生成
        virtual void Generate(uint16_t nData)
        {
            for (int k=0; k<nData; k++)
                Set(k, 0.54f - 0.46f*cosf(k*PI2L_));
        }

        // コピー･コンストラクタおよび代入演算子の禁止のため
        HammingWindow(const HammingWindow& );
        HammingWindow& operator=(const HammingWindow& );
    };
}
#endif  // HAMMING_WINDOW_HPP