//-------------------------------------------------------------------
//  Blackman 窓による窓掛け
//      ゼロ詰め（zero-padding）の機能を持つ
//
//  2021/11/10, Copyright (c) 2021 MIKAMI, Naoki
//-------------------------------------------------------------------

#ifndef BLACKMAN_WINDOW_HPP
#define BLACKMAN_WINDOW_HPP

#include "WindowBase.hpp"

namespace Mikami
{
    class BlackmanWindow : public WindowBase
    {
    public:
        // コンストラクタ
        BlackmanWindow(uint16_t nFft, uint16_t nData)
            : WindowBase(nFft, nData) { Generate(nData); }
        explicit BlackmanWindow(uint16_t nFft)
            : WindowBase(nFft, nFft) { Generate(nFft); }

    private:
        // 窓関数を生成
        virtual void Generate(uint16_t nData)
        {
            // k = 0 で値が 0 になるようにするため，計算の順番を変えている
            for (int k=0; k<nData; k++)
                Set(k, 0.42f + 0.08f*cosf(2*k*PI2L_) - 0.5f*cosf(k*PI2L_));
        }

        // コピー･コンストラクタおよび代入演算子の禁止のため
        BlackmanWindow(const BlackmanWindow& );
        BlackmanWindow& operator=(const BlackmanWindow& );
    };
}
#endif  // BLACKMAN_WINDOW_HPP