//------------------------------------------------------------------------------
//  出力ポートを，オープンドレインまたはプッシュプルに設定するグローバル関数
//  (Global functions for setting the output port bit open-drain or push-pull)
//      SetOpenDrain()      オープンドレインに設定 (Set open-drain)
//      SetPushPull()       プッシュプルに設定 (Set push-pull)
//  Nucleo 用（For Nucleo）
//
//  "PA_0", "PB_0", "PC_0" などの定義：PinNames.h
//  "PA_0", "PB_0", "PC_0", etc. are defined in PinNames.h.
//
//  この関数を使う前に，使用する GPIO ポートは使える状態に設定しておくこと
//  (Before using this function, the GPIO port must be enabled.)
//
//      PinName 型変数の 4 ～ 7 ビット：ポート番号（0 = A, 1 = B, ･････）
//      PinName 型変数の 0 ～ 3 ビット：ピン番号(0 ～ 15)
//
//  STM_PORT(), STM_PIN() は
//      mbed\TARGET_NUCLEO_F446RE\TARGET_STM\PinNamesTypes.h 参照
//
//  2019/12/17, Copyright (c) 2019 MIKAMI, Naoki
//------------------------------------------------------------------------------

#include "mbed.h"

#ifndef SET_OUTPUT_PORT_TYPE_HPP
#define SET_OUTPUT_PORT_TYPE_HPP

namespace Mikami
{
    // 出力ポートをオープンドレインに設定する
    void SetOpenDrain(PinName p0,       PinName p1  = NC, PinName p2  = NC,
                      PinName p3  = NC, PinName p4  = NC, PinName p5  = NC,
                      PinName p6  = NC, PinName p7  = NC, PinName p8  = NC,
                      PinName p9  = NC, PinName p10 = NC, PinName p11 = NC,
                      PinName p12 = NC, PinName p13 = NC, PinName p14 = NC,
                      PinName p15 = NC)
    {
        PinName pins[16] = { p0,  p1,  p2,  p3,  p4,  p5,  p6,  p7,
                             p8,  p9, p10, p11, p12, p13, p14, p15};

        for (int n=0; n<16; n++)
        {
            if (pins[n] == NC) break;
            uint32_t address = (STM_PORT(pins[n]) << 10) + GPIOA_BASE;
            ((GPIO_TypeDef *)address)->OTYPER |= 1 << STM_PIN(pins[n]);
        }
    }

    // 出力ポートをプッシュプルに設定する
    void SetPushPull(PinName p0,       PinName p1  = NC, PinName p2  = NC,
                     PinName p3  = NC, PinName p4  = NC, PinName p5  = NC,
                     PinName p6  = NC, PinName p7  = NC, PinName p8  = NC,
                     PinName p9  = NC, PinName p10 = NC, PinName p11 = NC,
                     PinName p12 = NC, PinName p13 = NC, PinName p14 = NC,
                     PinName p15 = NC)
    {
        PinName pins[16] = { p0,  p1,  p2,  p3,  p4,  p5,  p6,  p7,
                             p8,  p9, p10, p11, p12, p13, p14, p15};

        for (int n=0; n<16; n++)
        {
            if (pins[n] == NC) break;
            uint32_t address = (STM_PORT(pins[n]) << 10) + GPIOA_BASE;
            ((GPIO_TypeDef *)address)->OTYPER &= ~(1 << STM_PIN(pins[n]));
        }
    }
}
#endif  // SET_OUTPUT_PORT_TYPE_HPP