//----------------------------------------------------------------
//  縦続形 IIR フィルタ（Biquad クラスを使用）
//  Class for IIR filter of cascade structure using Biquad class
//  2015/09/11, Copyright (c) 2015 MIKAMI, Naoki
//----------------------------------------------------------------

#ifndef IIR_CASCADE_HPP
#define IIR_CASCADE_HPP

#include "Biquad.hpp"

namespace Mikami
{
    // IIR filter -- Cascade structure
    template<int order> class IirCascade
    {
    public:
        IirCascade() : g0_(0) {}
        IirCascade(float g0, const Biquad::Coefs ck[])
        { SetCoefs(g0, ck); }

        void SetCoefs(float g0, const Biquad::Coefs ck[])
        {
            g0_ = g0;
            for (int k=0; k<order/2; k++)
                hk_[k].SetCoefs(ck[k]);
        }

        float Execute(float xn)
        {
            float yn = g0_*xn;
            for (int k=0; k<order/2; k++)
                yn = hk_[k].Execute(yn);
                
            return yn;
        }
        
        void Clear()
        {
            for (int k=0; k<order/2; k++)
                hk_[k].Clear();
        }
    private:
        Biquad hk_[order/2];    // Elements of cascade structure
        float g0_;              // gain factor

        // disallow copy constructor and assignment operator
        IirCascade(const IirCascade&);
        IirCascade& operator=(const IirCascade&);
    };
}
#endif  // IIR_CASCADE_HPP
