//-------------------------------------------------------------------
//  データが実数の場合の FFT class（ヘッダ）
//
//  2020/12/12, Copyright (c) 2020 MIKAMI, Naoki
//-------------------------------------------------------------------

#ifndef FFT_REAL_HPP
#define FFT_REAL_HPP

#include "Array.hpp"    // "Array_Matrix" という名前で Mbed に登録
#include <complex>      // complex で使用

namespace Mikami
{
    typedef complex<float> Complex; // "Complex" の定義

    class FftReal
    {
    public:
        // コンストラクタ
        explicit FftReal(int16_t n);
        // FFT の実行
        void Execute(const float x[], Complex y[]);
        // IFFT の実行
        void ExecuteIfft(const Complex y[], float x[]);

    private:
        const int   N_FFT_;
        const float N_INV_;
        Array<Complex>    wTable_;  // 回転子
        Array<uint16_t>   bTable_;  // ビット逆順
        Array<Complex>    u_;       // 作業領域

        // 最終ステージを除いた処理
        void ExcludeLastStage();
        // IFFT のビット逆順の並べ替えで使用
        int Index(int n) const { return (N_FFT_-bTable_[n]); }

        // コピー･コンストラクタおよび代入演算子の禁止のため
        FftReal(const FftReal& );
        FftReal& operator=(const FftReal& );
    };
}
#endif  // FFT_REAL_HPP
