//----------------------------------------------------------------------------
//  出力端子をオープンドレインに設定できるように拡張した DigitalOut クラスの派生クラス
//      Nucleo 用
//      デフォルトではオープンドレインに設定される
//
//  DigitalOut クラス： mbed\drivers\DigitalOut.h を参照
//  gpio_t 構造体： mbed\TARGET_NUCLEO_F446RE\TOOLCHAIN_ARM_STD\gpio_object.h を参照
//      gpio_t のメンバの主なものの説明：
//          ll_pin  ピン番号に対応するビットの位置
//          gpio    GPIO_TypeDef 構造体のポインタ
//
//  2019/11/01, Copyright (c) 2019 MIKAMI, Naoki
//----------------------------------------------------------------------------

#ifndef DIGITAL_OUT_EX_HPP
#define DIGITAL_OUT_EX_HPP

#include "mbed.h"

namespace Mikami
{
    class DigitalOutEx : public DigitalOut
    {
    public:
        enum OutPinType {PushPull, OpenDrain};

        // 出力の初期値を設定しないコンストラクタ
        DigitalOutEx(PinName pin, OutPinType type = OpenDrain)
            : DigitalOut(pin) { Initialize(type); }

        // 出力の初期値を設定するコンストラクタ
        DigitalOutEx(PinName pin, int value, OutPinType type = OpenDrain)
            : DigitalOut(pin, value) { Initialize(type); }

        // 出力のピンをオープンドレインの状態に設定する
        void SetOpenDrain() { (gpio.gpio)->OTYPER |= gpio.ll_pin; }

        // 出力のピンをプッシュプルの状態に設定する
        void SetPushPull() { (gpio.gpio)->OTYPER &= ~gpio.ll_pin; }

        // 代入演算子は継承されないので新たに定義する必要がある
        DigitalOutEx& operator=(int value)
        {
            write(value);
            return *this;
        }

    private:
        void Initialize(OutPinType type) { if (type == OpenDrain) SetOpenDrain(); }

        // コピー･コンストラクタとオブジェクトの代入演算子は使用禁止
        DigitalOutEx(const DigitalOutEx&);
        DigitalOutEx& operator = (const DigitalOutEx&);
    };
}
#endif  // DIGITAL_OUT_EX_HPP

