//-------------------------------------------------------
//  Class for LCD, AQM0802A
//
//  2014/12/21, Copyright (c) 2014 MIKAMI, Naoki
//-------------------------------------------------------

#include "AQM0802_I2C.hpp"

namespace Mikami
{
    // Constructor
    Aqm0802A::Aqm0802A(PinName sda, PinName scl, uint32_t clock,
                       bool cursor, bool blink)
        : i2c_(sda, scl)
    {
        if (clock != 100000) i2c_.frequency(clock);

        wait_ms(40);
        WriteCmd(0x39); // To extended command
        WriteCmd(0x14); // Internal OSC frequency
        WriteCmd(0x70 | 0x00); // Contrast set
        WriteCmd(0x54 | 0x02); // Power/ICON/Contrast control
        WriteCmd(0x6C); // Follower control
        wait_ms(200);

        WriteCmd(0x38); // data length：8-bit, 2-line, 5×8 dots
        WriteCmd(0x0C | (cursor << 1) | blink);
        Clear();      // Clear display
    }

    // All clear
    void Aqm0802A::Clear()
    {
        WriteCmd(0x01);
        wait_ms(50);
    }

    // Write string
    void Aqm0802A::WriteString(const char str[])
    {
        for (int n=0; n<8; n++)
            if (str[n] == 0) break;
            else             WriteChar(str[n]);
    }

    // Write string from specified position
    void Aqm0802A::WriteStringXY(const char str[],
                                 uint8_t x, uint8_t y)
    {
        SetXY(x, y);
        WriteString(str);
    }

    // Set contrast
    void Aqm0802A::SetContrast(uint8_t c)
    {
        WriteCmd(0x39);
        WriteCmd(0x70 | (c & 0x0f));         // Lower 4 bits
        WriteCmd(0x5C | ((c >> 4) & 0x03));  // Higher 2 bits
        WriteCmd(0x38);
    }

    //---------------------------------------------------
    // Following functions: private

    // Send command and data
    void Aqm0802A::LcdTx(uint8_t cmdData, uint8_t data)
    {
        char tx[2];
        tx[0] = cmdData;
        tx[1] = data;
        i2c_.write(LCD_ADDRESS_, tx, 2);
    }
}


