//------------------------------------------------------
// Class for single DAC in MCP4921
//
// 2015/02/02, Copyright (c) 2015 MIKAMI, Naoki
//------------------------------------------------------

#include "DAC_MCP4921.hpp"

namespace Mikami
{
    DAC_MCP4921::DAC_MCP4921(PinName mosi, PinName sclk,
                             PinName cs, PinName ldac)
        : spi_(mosi, NC, sclk),
          ld_(ldac, 0), mySpi_((SPI_TypeDef*)NULL)
    {
        if ( (mosi == PA_7) || (mosi == PB_5) )  mySpi_ = SPI1;
        if ( (mosi == PB_15) || (mosi == PC_3) ) mySpi_ = SPI2;
        if ( mosi == PC_12 )                     mySpi_ = SPI3;

        // Set SPI format
        spi_.format(16, 0);
        // Clock source of F401 for SPI1    : 84 MHz,
        //                      SPI2, SPI3  : 42 MHz
        mySpi_->CR1 = (mySpi_->CR1 & ~SPI_CR1_BR);
        if (mySpi_ == SPI1) mySpi_->CR1 += SPI_CR1_BR_0;
#ifdef __STM32F411xE_H
        mySpi_->CR1 += SPI_CR1_BR_0;
#endif  // __STM32F411xE_H
        
        // timer prescaler is set same value of boud rate for SPI
        uint16_t psc = (2 << ((mySpi_->CR1 >> 3) & 0x07)) - 1;
        if (mySpi_ != SPI1) psc = (psc + 1)*2 - 1;
        ss_ = new Tim4_ss(psc, 19, cs);
    }

    void DAC_MCP4921::ScfClockTim3(uint32_t clock, PinName pin)
    {
        if ( (pin != PA_6) && (pin != PB_4) && (pin != PB_5) &&
             (pin != PC_6) && (pin != PC_7) && (pin != PC_8) && (pin != PC_9) )
        {
            fprintf(stderr, "\r\nIllegal pin name in DAC_MCP4921::ScfClockTim3()\r\n");
            while (true) {}
        }

        PwmOut clockSCF(pin);
        
        TIM3->ARR =  SystemCoreClock/clock - 1;
        TIM3->PSC = 0;
        // Set capture/compare register 2
        if ( (pin == PA_6) || (pin == PB_4) || (pin == PC_6) )
            TIM3->CCR1 = (TIM3->ARR + 1)/2;    
        if ( (pin == PB_5) || (pin == PC_7) )
            TIM3->CCR2 = (TIM3->ARR + 1)/2;    
        if (pin == PC_8)
            TIM3->CCR3 = (TIM3->ARR + 1)/2;    
        if (pin == PC_9)
            TIM3->CCR4 = (TIM3->ARR + 1)/2;    
    }
}
