//------------------------------------------------------
//  Class for generate SPI slave select using TIM4
//
//  Default pin assignments: PB_6 (D10)
//  PB_7, PB_8 (D15), and PB_9 (D14) also can be used
//  2014/12/21, Copyright (c) 2014 MIKAMI, Naoki
//------------------------------------------------------

#ifndef TIM4_SLAVESELECT_HPP
#define TIM4_SLAVESELECT_HPP

#include "mbed.h"

namespace Mikami
{
    class Tim4_ss
    {
    public:
        Tim4_ss(uint16_t psc,       // prescaler
                uint16_t arr = 18,  // auto-reload register
                PinName pin = PB_6) // pin name
                : myTim_(TIM4)
        {
            PwmOut css(pin);
            myTim_->CR1 |= TIM_CR1_OPM; // one-pulse mode
            myTim_->PSC = psc;          // prescaler
            myTim_->ARR = arr;          // pulse width
            if (pin == PB_6) myTim_->CCR1 = 1;
            if (pin == PB_7) myTim_->CCR2 = 1;
            if (pin == PB_8) myTim_->CCR3 = 1;
            if (pin == PB_9) myTim_->CCR4 = 1;
            if ( (pin != PB_6) && (pin != PB_7)
               &&(pin != PB_8) && (pin != PB_9) )
            {
                fprintf(stderr, "\r\nIllegal pin name in Tim4_ss class\r\n");
                while (true) {}
            }
        }
        // Generate slave select
        void SlaveSelect()
        {
            myTim_->CNT = 0;            // Set counter 0
            myTim_->CR1 |= TIM_CR1_CEN; // Enable TIM4
            __NOP();
            __NOP();
            __NOP();
            __NOP();
#ifdef __STM32F411xE_H
            __NOP();
            __NOP();
#endif  // __STM32F411xE_H
        }
    private:
        TIM_TypeDef* myTim_;

        // Forbid to use copy constructor
        Tim4_ss(const Tim4_ss&);
        // Forbid to use substitution operator
        Tim4_ss operator=(const Tim4_ss&);
    };
}
#endif  // TIM4_SLAVESELECT_HPP
