//------------------------------------------------------
// Class for single DAC in MCP4922 -- Header
//      Fast version
//
// 2015/02/03, Copyright (c) 2015 MIKAMI, Naoki
//------------------------------------------------------

#ifndef DAC_MCP4922_HPP
#define DAC_MCP4922_HPP

#include "DAC_MCP4921.hpp"

namespace Mikami
{
    class DAC_MCP4922 : public DAC_MCP4921
    {
    public:
        enum DAC { DAC_A = 0, DAC_B = 0x8000 };

        // Constructor
        DAC_MCP4922(
            DAC dac = DAC_A,            // channel A
            PinName mosi = SPI_MOSI,    // D11
            PinName sclk = SPI_SCK,     // D13
            PinName cs   = SPI_CS,      // D10
            PinName ldac = SPI_MISO)    // D12
                : DAC_MCP4921(mosi, sclk, cs, ldac),
                  wcr_(dac | 0x3000) {}

    protected:
        void SetCR(DAC dac) { wcr_ = dac  | 0x3000; }
        
    private:
        uint16_t wcr_;  // write command register

        // for inhibition of copy constructor
        DAC_MCP4922(const DAC_MCP4922&);
        // for inhibition of substitute operator
        DAC_MCP4922& operator=(const DAC_MCP4922&);     
        
        // for internal use
        virtual void WriteDac(uint16_t value)
        {
            while (IsBusy()) {}
            SlaveSelect();
            WriteSpi(value | wcr_);
        }
    };
}
#endif  // DAC_MCP4922_HPP

