//------------------------------------------------------
// Class for dual channel DAC in MCP4922
// 2015/02/03, Copyright (c) 2015 MIKAMI, Naoki
//------------------------------------------------------

#ifndef DAC_MCP4922_DUAL_HPP
#define DAC_MCP4922_DUAL_HPP

#include "DAC_MCP4922.hpp"

namespace Mikami

{
    class DAC_MCP4922Dual : public DAC_MCP4922
    {
    public:
        DAC_MCP4922Dual(
            PinName mosi = SPI_MOSI,    // D11
            PinName sclk = SPI_SCK,     // D13
            PinName cs   = SPI_CS,      // D10
            PinName ldac = SPI_MISO)    // D12
                : DAC_MCP4922(DAC_A, mosi, sclk, cs, ldac) {}


        void Write(float valA, float valB)
        {
            SetCR(DAC_A);
            DAC_MCP4922::Write(valA);   // Write to DAC A
            SetCR(DAC_B);
            DAC_MCP4922::Write(valB);   // Write to DAC B
            Wait();
            while (IsBusy()) {}
            Ldac();
        }

        void Write(uint16_t valA, uint16_t valB)
        {
            SetCR(DAC_A);
            DAC_MCP4922::Write(valA);   // Write to DAC A
            SetCR(DAC_B);
            DAC_MCP4922::Write(valB);   // Write to DAC B
            Wait();
            while (IsBusy()) {}
            Ldac();
        }
    };
}
#endif  // DAC_MCP4922_DUAL_HPP
