//------------------------------------------------------
// Derived class of ADC_Base for use interrupt
//
// 2014/10/04, Copyright (c) 2014 MIKAMI, Naoki
//------------------------------------------------------

#ifndef ADC_INTERRUPT_HPP
#define ADC_INTERRUPT_HPP

#include "ADC_Base.hpp"

namespace Mikami
{
    class ADC_Intr : public ADC_Base
    {
    private:       
        // for inhibition of copy constructor
        ADC_Intr(const ADC_Intr&);
        // for inhibition of substitute operator
        ADC_Intr& operator=(const ADC_Intr&);

    public:
        ADC_Intr(PinName pin1, int frequency,
                 PinName pin2 = NC, PinName pin3 = NC)
            : ADC_Base(pin1, frequency, pin2, pin3)
        { myAdc_->CR1 |= ADC_CR1_EOCIE; }   // Interrupt enable

        // Set interrupt vector and enable IRQ of ADC
        void SetIntrVec(void (*Func)())
        {
            NVIC_SetVector(ADC_IRQn, (uint32_t)Func);   // See "cmsis_nvic.h"
            NVIC_EnableIRQ(ADC_IRQn);                   // See "core_cm4.h"
        }       

        // Read ADC, range: [0, 0x0FFF]
        virtual uint16_t Read_u16()
        { return myAdc_->DR; }

        // Read ADC, range: [0, 0x0FFF]
        virtual uint16_t ReadWait_u16()
        {
            WaitDone();
            return myAdc_->DR;
        }

        // Read ADC, range: [-1.0f, 1.0f]
        virtual float Read()
        { return AMP_*((int16_t)myAdc_->DR - 2048); }
        
        // Clear pending IRQ and enable IRQ
        void ClearPending_EnableIRQ()
        {
            NVIC_ClearPendingIRQ(ADC_IRQn);
            NVIC_EnableIRQ(ADC_IRQn);
        }

        // Software start with disable IRQ
        virtual void SoftStart()
        {
            NVIC_DisableIRQ(ADC_IRQn);
            myAdc_->CR2 |= ADC_CR2_SWSTART;
        }        
    };
}
#endif  // ADC_INTERRUPT_HPP
