//------------------------------------------------------
//  Class for Internal ADC using Ticker for trigger
//      To get bit definition for registers in
//      peripheral, see "stm32f401xe.h"
//
//  2015/01/27, Copyright (c) 2015 MIKAMI, Naoki
//------------------------------------------------------

#include "InternalADC.hpp"

namespace Mikami
{
    InternalADC::InternalADC(PinName pin1,
                             PinName pin2, PinName pin3)
        : adc_(pin1), myAdc_(ADC1)
    {
        myAdc_->CR2 = ADC_CR2_ADON;     // Enable ADC
        
        ch1_ = GetChannelNumber(pin1);
        if (pin2 != NC)
        {
            adc2_ = new AnalogIn(pin2);
            ch2_ = GetChannelNumber(pin2);
        }
        if (pin3 != NC)
        {
            adc3_ = new AnalogIn(pin3);
            ch3_ = GetChannelNumber(pin3);
        }
        Select1stChannel();
    }
}

