//--------------------------------------------------------------
//  Class for DAC MCP4921
//
//  2015/02/18, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#include "InterruptManager.h"
#include "DAC_MCP4921.hpp"

namespace Mikami
{
    DAC_MCP4921::DAC_MCP4921(PinName mosi, PinName sclk,
                             PinName cs, PinName ldac)
        : spi_(mosi, NC, sclk), ld_(ldac, 0)
    {
        if ( (mosi == PA_7) || (mosi == PB_5) )  mySpi_ = SPI1;
        if ( (mosi == PB_15) || (mosi == PC_3) ) mySpi_ = SPI2;
        if ( mosi == PC_12 )                     mySpi_ = SPI3;

        // Set SPI format
        spi_.format(16, 0);
        // Clock source of F401 for SPI1    : 84 MHz,
        //                      SPI2, SPI3  : 42 MHz
        mySpi_->CR1 = (mySpi_->CR1 & ~SPI_CR1_BR);
        if (mySpi_ == SPI1) mySpi_->CR1 += SPI_CR1_BR_0;
#ifdef __STM32F411xE_H
        mySpi_->CR1 += SPI_CR1_BR_0;
#endif  // __STM32F411xE_H
        
        cs_ = new DigitalOut(cs, 1);

        mySpi_->CR2 |= SPI_CR2_RXNEIE;   // Enable SPI RX buffer not empty interrupt

        IRQn_Type irq = SPI1_IRQn;
        if (mySpi_ == SPI2) irq = SPI2_IRQn;
        if (mySpi_ == SPI3) irq = SPI3_IRQn;
        
        NVIC_SetVector(irq, (uint32_t)Isr); // See "cmsis_nvic.h"
        NVIC_EnableIRQ(irq);                // See "core_cm4.h"
    }

    void DAC_MCP4921::ScfClockTim3(uint32_t clock, PinName pin)
    {
        if ( (pin != PA_6) && (pin != PB_4) && (pin != PB_5) &&
             (pin != PC_6) && (pin != PC_7) && (pin != PC_8) && (pin != PC_9) )
        {
            fprintf(stderr, "\r\nIllegal pin name in DAC_MCP4922::ScfClockTim3()\r\n");
            while (true) {}
        }

        PwmOut clockSCF(pin);
        
        TIM3->ARR =  SystemCoreClock/clock - 1;
        TIM3->PSC = 0;
        // Set capture/compare register 2
        if ( (pin == PA_6) || (pin == PB_4) || (pin == PC_6) )
            TIM3->CCR1 = (TIM3->ARR + 1)/2;    
        if ( (pin == PB_5) || (pin == PC_7) )
            TIM3->CCR2 = (TIM3->ARR + 1)/2;    
        if (pin == PC_8)
            TIM3->CCR3 = (TIM3->ARR + 1)/2;    
        if (pin == PC_9)
            TIM3->CCR4 = (TIM3->ARR + 1)/2;    
    }
    
    DigitalOut* DAC_MCP4921::cs_;
    SPI_TypeDef* DAC_MCP4921::mySpi_;
}

