//--------------------------------------------------------------
//  Class for generate SPI slave select using TIM4
//
//  PB_6 (D10), PB_7, PB_8 (D15), and PB_9 (D14) can be used
//  2015/03/31, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef TIM4_SLAVESELECT_HPP
#define TIM4_SLAVESELECT_HPP

#include "mbed.h"

namespace Mikami
{
    class TIM4_SlaveSelect
    {
    public:
        TIM4_SlaveSelect(
            uint16_t psc,   // prescaler
            uint16_t arr,   // auto-reload register
            PinName pin)    // pin name
            : myTim_(TIM4)
        {
            if ( (pin != PB_6) && (pin != PB_7)
               &&(pin != PB_8) && (pin != PB_9) )
            {
                fprintf(stderr, "\r\nIllegal pin name in TIM4_SlaveSelect\r\n");
                while (true) {}
            }

            PwmOut css(pin);            // for slave select
            myTim_->CR1 |= TIM_CR1_OPM; // one-pulse mode
            myTim_->PSC = psc;          // prescaler
            myTim_->ARR = arr;          // pulse width
            if (pin == PB_6) myTim_->CCR1 = 1;
            if (pin == PB_7) myTim_->CCR2 = 1;
            if (pin == PB_8) myTim_->CCR3 = 1;
            if (pin == PB_9) myTim_->CCR4 = 1;
        }

        // Generate slave select
        void SlaveSelect()
        {
            myTim_->CNT = 1;            // Set counter 1
            myTim_->CR1 |= TIM_CR1_CEN; // Enable TIM4
        }

    private:
        TIM_TypeDef* const myTim_;

        // Forbid to use copy constructor
        TIM4_SlaveSelect(const TIM4_SlaveSelect&);
        // Forbid to use substitution operator
        TIM4_SlaveSelect operator=(const TIM4_SlaveSelect&);
    };
}
#endif  // TIM4_SLAVESELECT_HPP
