//------------------------------------------------------------------------------
//  音声合成で使う共振器
//      作成者：三上直樹，2013/11/27 作成，(c)三上直樹 2013
//------------------------------------------------------------------------------

#include "Resonator.hpp"

namespace Mikami
{
    // コンストラクタに共通な初期化
    void Resonator::Initialize(float fr, float bw, float fs)
    {
        if (piT_ == 0) piT_ = 3.14159265f/fs;
        Set(fr, bw);
        Clear();
    }

    // 共振器のパラメータの設定
    void Resonator::Set(float fr, float bw)
    {
        a1_ = 2.0f*exp(-piT_*bw)*cos(2.0f*piT_*fr);
        a2_ = -exp(-2.0f*piT_*bw);
        b0_ = 1.0f - a1_ - a2_;
    }

    // 共振器に対応する処理の実行
    float Resonator::Execute(float xin)
    {
        float ym = a1_*yn1_ + a2_*yn2_ + b0_*xin;
        yn2_ = yn1_;    // 遅延器のデータの移動
        yn1_ = ym;      // 遅延器のデータの移動
        return ym;
    }

    // "π/標本化周波数" の値に対応する実体
    float Resonator::piT_ = 0;
}

