//------------------------------------------------------------------------------
//  口からの放射の効果（ヘッダ）
//      作成者：三上直樹，2013/11/26 作成，(c)三上直樹 2013
//------------------------------------------------------------------------------

#include "mbed.h"

#ifndef RADIATOR_HPP
#define RADIATOR_HPP

namespace Mikami
{
    class Radiator
    {
    private:
        const float C1_;
        float xnM1_;

        // コピー･コンストラクタの使用禁止
        Radiator(const Radiator& g);
        // 代入演算子の使用禁止
        Radiator& operator=(const Radiator& g);

    public:
        // デフォルト･コンストラクタ
        explicit Radiator(float c1 = 1.0f) : C1_(c1) { Clear(); }

        // 差分に対応する処理の実行
        float Execute(float xin)
        {
            float yn = xin - C1_*xnM1_;
            xnM1_ = xin;    // x[n-1] ← x[n]
            return yn;
        }

        // 内部の遅延器のクリア
        void Clear() { xnM1_ = 0; }
    };
}
#endif  // RADIATOR_HPP
