//------------------------------------------------------------------------------
//  Design of FIR filter of LPF and HPF using window method -- Header
//
//  2014/11/09, Copyright (c) 2014 MIKAMI, Naoki
//------------------------------------------------------------------------------

#ifndef HAMMING_WINDOWING_DESIGN_HPP
#define HAMMING_WINDOWING_DESIGN_HPP

#include "mbed.h"

namespace Mikami
{
    class WindowingDesign
    {
    public:
        struct Coefs { float a1, a2, b1; };
        enum Type { LPF, HPF };

        // Constructor
        WindowingDesign(int order, float fs);

        //Destructor
        ~WindowingDesign()
        {
            delete[] hm_;
            delete[] wn_;
        }

        // Execution of design
        void Design(int order, Type pb, float fc, float hk[]);

    private:
        static const float PI_ = 3.1415926536f;
        const float FS_;    // Sampling frequency
        const float PI_FS_;
        
        float *hm_;     // For coefficients
        float *wn_;     // For Windwo
                
        int order_;     // Order
        float fC_;      // Cutoff frequency
        
        // Calculation of coefficients for LPF
        void LpfCoefficients();
        // Transform LPF to HPF
        void ToHpf();
        // Hamming window
        void HammWindow();
    };
}
#endif  // HAMMING_WINDOWING_DESIGN_HPP
