//--------------------------------------------------------------
// Two-phase sinusoidal wave generator
// 2015/02/02, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"             // for ADC not using interrupt
#include "DAC_MCP4922Dual.hpp"      // for DAC MCP4922

#include "TwoPhaseGenerator.hpp"    // Two-phase generator

using namespace Mikami;

const int FS_ = 12000;  // 12 kHz
ADC_Base adc_(A0, FS_);
DAC_MCP4922Dual myDac_;

int main()
{
    TwoPhaseGenerator gen(1500, (float)FS_);
    while (true)
    {
        float xn = adc_.Read();     // Read from A0
        //-----------------------------------------------

        float cos, sin;
        gen.Generate(cos, sin);
        
        //-----------------------------------------------
        myDac_.Write(cos, sin);     // Write to DAC  
    }
}
