//--------------------------------------------------------------
// Two phase sin generator class
// 2014/10/22, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef TWO_PHASE_GENERATOR_HPP
#define TWO_PHASE_GENERATOR_HPP

#include "mbed.h"

namespace Mikami
{
    class TwoPhaseGenerator
    {
    public:
        // Constructor
        TwoPhaseGenerator(float f0, float fs)
            : a1_(cosf(6.283185f*f0/fs)),
              b1_(sinf(6.283185f*f0/fs)),
              xn1_(1.0f), yn1_(0.0f) {}

        // -1.0f <= x1, x2 <= 1.0f
        void Generate(float& xn, float& yn)
        {
            yn = a1_*yn1_ + b1_*xn1_;     // sin
            xn = -b1_*yn1_ + a1_*xn1_;    // cos

            float c1 = 1.5f - 0.5f*(xn*xn + yn*yn);

            xn1_ = c1*xn;
            yn1_ = c1*yn;
        }

    private:
        const float a1_, b1_;
        float xn1_, yn1_;

        TwoPhaseGenerator(const TwoPhaseGenerator&);
        TwoPhaseGenerator& operator=(const TwoPhaseGenerator&);
    };
}
#endif  // TWO_PHASE_GENERATOR_HPP
