//--------------------------------------------------------------
// Analytic signal generator
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"             // for ADC not using interrupt
#include "DAC_MCP4922Dual.hpp"      // for DAC MCP4922

#include "HilbertTransform.hpp"     // Hilbert transform filter
#include "coefsHilbert114.hpp"      // Coeffisients of Hilbert transform filter
#include "DC_Cut_Coefficients.hpp"  // Coeffisients of DC-cut filter
#include "Biquad.hpp"               // For DC-cut filter

using namespace Mikami;

const int FS_ = 12000;  // 12 kHz
ADC_Base adc_(A0, FS_);
DAC_MCP4922Dual myDac_;

Hilbert<ORDER_> ht_(hm_);
Biquad DcCut_(c1_);      // DC cut filter

int main()
{
    while (true)
    {
        float xn = adc_.Read();     // Read from A0
        //-----------------------------------------------

        xn = DcCut_.Execute(g0_*xn); // DC cut filter
        float yIn, yQn;
        ht_.Execute(xn, yIn, yQn);   // Hilbert transform filter
        
        //-----------------------------------------------
        myDac_.Write(yIn, yQn);    // Write to DAC  
    }
}
