//---------------------------------------------------------------
// Class for spectrum analysis using linear prediction (Header)
// Copyright (c) 2014 MIKAMI, Naoki,  2014/12/30
//---------------------------------------------------------------

#ifndef LPC_ANALYZER_HPP
#define LPC_ANALYZER_HPP

#include "fftReal.hpp"
#include "Hamming.hpp"
#include "PeakHolder.hpp"
#include "LinearPrediction.hpp"

namespace Mikami
{
    class LpcAnalyzer
    {
    public:
        LpcAnalyzer(int nData, int order, int nFft);
        ~LpcAnalyzer();
        void Execute(float xn[], float db[]);
    private:
        const int N_DATA_;
        const int ORDER_;
        const int N_FFT_;

        HammingWindow hm_;
        LinearPred lp_;
        FftReal fft_;
        PeakHolder* pkHolder_;

        float* xData_;   // Data to be analyzed
        float* an_;
        float* xFft_;    // Input for FFT
        Complex* yFft_;  // Output of FFT
        float* normY_;   // Powerspectrum

        float Sqr(float x) { return x*x; }
    };
}
#endif  // LPC_ANALYZER_HPP

