//-------------------------------------------------------
// Class for spectrum analysis using FFT (Header)
// Copyright (c) 2014 MIKAMI, Naoki,  2014/12/30
//-------------------------------------------------------

#ifndef FFT_ANALYZER_HPP
#define FFT_ANALYZER_HPP

#include "fftReal.hpp"
#include "Hamming.hpp"
#include "PeakHolder.hpp"

namespace Mikami
{
    class FftAnalyzer
    {
    public:
        FftAnalyzer(int nData, int nFft);
        ~FftAnalyzer();
        void Execute(float xn[], float db[]);

    private:
        const int N_DATA_;
        const int N_FFT_;

        HammingWindow hm_;
        FftReal fft_;
        PeakHolder* pkHolder_;

        float* xData;   // Data to be analyzed
        float* xFft;    // Input for FFT
        Complex* yFft;  // Output of FFT
        float* normY;   // Powerspectrum

        float Sqr(float x) { return x*x; }
    };
}

#endif  // FFT_ANALYZER_HPP
