//-------------------------------------------------------------------
// Hamming windowing with zero-padding
// Copyright (c) 2014 MIKAMI, Naoki,  2014/12/21
//-------------------------------------------------------------------

#ifndef HAMMING_WINDOW_HPP
#define HAMMING_WINDOW_HPP

#include "mbed.h"

namespace Mikami
{
    class HammingWindow
    {
    private:
        const int N_;
        const int NFFT_;
                
        float* w_;

    public:
        // Constructor
        HammingWindow(uint16_t nData, uint16_t nFft)
                : N_(nData), NFFT_(nFft)
        {
            w_ = new float[nData];
            float pi2L = 6.283185f/(float)nData;
            for (int k=0; k<nData; k++)
                w_[k] = 0.54f - 0.46f*cosf(k*pi2L);
        }
        
        // Destructor
        ~HammingWindow() {delete[] w_;}
        
        // Windowing
        void Execute(const float x[], float y[])
        {
            for (int n=0; n<N_; n++) y[n] = x[n]*w_[n];
            for (int n=N_; n<NFFT_; n++) y[n] = 0;
        }
    };
}
#endif  // HAMMING_WINDOW_HPP

