//-------------------------------------------------------
// Class for display spectrum
// Copyright (c) 2014 MIKAMI, Naoki,  2014/12/28
//-------------------------------------------------------

#ifndef SPECTRUM_DISPLAY_HPP
#define SPECTRUM_DISPLAY_HPP

// Following two files were imported from
// http://developer.mbed.org/teams/shields/code/
// Seeed_TFT_Touch_Shield/
#include "SeeedStudioTFTv2.h"   // imported
#include "Arial12x12.h"         // imported

namespace Mikami
{
    class SpectrumDisplay
    {
    public:
        SpectrumDisplay(SeeedStudioTFTv2* lcd,
                        int nFft, int x0, int y0,
                        float db1, int bin, float maxDb, int fs);
        void BarChart(float db[], float offset);
        void LineChart(float db[], float offset);
        void DisplayVolume(float volume);

    private:
        const int N_FFT_;       // number of date for FFT
        const int X0_;          // Origin for x axis
        const int Y0_;          // Origin for y axis
        const float DB1_;       // Pixels for 1 dB
        const int BIN_;         // Pixels per bin
        const float MAX_DB_;    // Maximum dB
        const int FS_;          // Sampling frequency: 10 kHz

        SeeedStudioTFTv2* lcd_;

        void AxisX();       // x-axis
        void AxisY();       // y-axis
    };
}
#endif  // SPECTRUM_DISPLAY_HPP
