//-------------------------------------------------------------------
// Peak holder
// Copyright (c) 2014 MIKAMI, Naoki,  2014/12/20
//-------------------------------------------------------------------

#ifndef PEAK_HOLDER_HPP
#define PEAK_HOLDER_HPP

#include "mbed.h"

namespace Mikami
{
    class PeakHolder
    {
    private:
        float a1_, b0_;
        float ynM1_;

    public:
        // Constructor
        explicit PeakHolder(float a1 = 0)
        {
            SetCoefs(a1);
            ynM1_ = 0;
        }
        
        // Argument a1 must be as follows: 0 < a1 < 1
        void SetCoefs(float a1)
        {
            a1_ = a1;
            b0_ =1.0f - a1;
        }
        
        float Execute(float xn)
        {
            float yn = xn;
            if (xn < ynM1_) yn = a1_*ynM1_ + b0_*xn;
            ynM1_ = yn;

            return yn;
        }
    };
}
#endif  // PEAK_HOLDER_HPP

