//-------------------------------------------------------
// Class for spectrum analysis using FFT
// Copyright (c) 2014 MIKAMI, Naoki,  2014/12/30
//-------------------------------------------------------

#include "FFT_Analysis.hpp"

namespace Mikami
{
    FftAnalyzer::FftAnalyzer(int nData, int nFft)
            : N_DATA_(nData), N_FFT_(nFft),
              hm_(nData-1, nFft), fft_(nFft)
    {
        pkHolder_ = new PeakHolder[nFft/2+1];
        for (int n=0; n<=nFft/2; n++)
            pkHolder_[n].SetCoefs(0.2f);    

        xData = new float[nData];       // Data to be analyzed
        xFft = new float[nFft];         // Input for FFT
        yFft = new Complex[nFft/2+1];   // Output of FFT
        normY = new float[nFft/2+1];    // Powerspectrum
    }
   
    FftAnalyzer::~FftAnalyzer()
    {
        delete[] pkHolder_;
        delete[] xData;
        delete[] xFft;
        delete[] yFft;
        delete[] normY;
    }

    void FftAnalyzer::Execute(float xn[], float db[])
    {
        // Differencing
        for (int n=0; n<N_DATA_-1; n++)
            xData[n] = xn[n+1] - xn[n];

        hm_.Execute(xData, xFft);    // Windowing and zero-padding
        fft_.Execute(xFft, yFft);    // Execute FFT

        // Smoothing
        for (int n=0; n<=N_FFT_/2; n++)
            normY[n] = pkHolder_[n].Execute(Sqr(yFft[n].real())
                     + Sqr(yFft[n].imag()));

        // Translate to dB
        for (int n=0; n<=N_FFT_/2; n++)
            db[n] = 10.0f*log10f(normY[n]);
    }
}
