//-----------------------------------------------------
// Class for linear prediction (Header)
// Copyright (c) 2014 MIKAMI, Naoki,  2014/12/30
//-----------------------------------------------------

#ifndef LINEAR_PREDICTION_HPP
#define LINEAR_PREDICTION_HPP

#include "mbed.h"

namespace Mikami
{
    class LinearPred
    {
    public:
        LinearPred(int nData, int order);
        ~LinearPred();
        bool Execute(const float x[], float a[], float &em);
    public:
        const uint16_t N_DATA_;
        const uint16_t ORDER_;

        float* r_;
        float* k_;
        float* am_;

        void AutoCorr(const float x[]);
        bool Durbin(float a[], float &em);
    };
}
#endif  // LINEAR_PREDICTION_HPP
