//--------------------------------------------------------------
// Sin generator using sinf() function
//      Analog Output: MCP4922 using SPI
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

int main()
{
    const float PI = 3.141593f;
    const float PI2 = PI*2;
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    float phi = 0;
    float dPhi = PI2*440.0f/(float)FS_;
    
    while (true)
    {
        float xn = adc_.Read();     // Dummy read for synchronization to Fs
        //-----------------------------------------------
        
        float yn = (float)(0.8f*sinf(phi));
        phi = phi + dPhi;
        if (phi > PI) phi = phi -PI2;

        //-----------------------------------------------
        myDac_.Write(yn);           // Write to DAC
    }
}
/*
// Following version uses double type variable
int main()
{
    const double PI = 3.1415926536;
    const double PI2 = PI*2;
    ScfClockTim3(500000);       // cutoff frequency: 5 kHz

    double phi = 0;
    double dPhi = PI2*440.0/(double)FS_;
    
    while (true)
    {
        float xn = adc_.Read();     // Dummy read to synchronize Fs
        //-----------------------------------------------
        dOut_.write(1);
        
        float yn = (float)(0.8*sin(phi));
        phi = phi + dPhi;
        if (phi > PI) phi = phi -PI2;

        dOut_.write(0);
        //-----------------------------------------------
        myDac_.Write(yn);           // Write to DAC
    }
}
*/