//--------------------------------------------------------------
// Sin generator using IIR filter
//      Analog Output: MCP4922 using SPI
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

int main()
{
    const float PI2 = 6.283185f;
    const float F0 = 440.0f;
    const float A1 = 2.0f*cosf(PI2*F0/(float)FS_);
    const float B1 = 0.8f*sinf(PI2*F0/(float)FS_);

    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    float yn1 = B1;
    float yn2 = 0;
    
    while (true)
    {
        float xn = adc_.Read();     // Dummy read for synchronization to Fs
        //-----------------------------------------------
        
        float yn = A1*yn1 - yn2;    // y[n] = a1*y[n-1] - y[n-2]
        yn2 = yn1;                  // y[n-2] <= y[n-1]
        yn1 = yn;                   // y[n-1] <= y[n]

        //-----------------------------------------------
        myDac_.Write(yn);           // Write to DAC
    }
}
