//--------------------------------------------------------------
// Reverb system using comb filter and allpass filter
//      sw number = even : No reverb
//      sw number = odd  : Reverb
// 2015/07/25, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#include "ADC_BuiltIn.hpp"      // for ADC not using interrupt
#include "DAC_MCP4921.hpp"      // for DAC MCP4921, MCP4922
#include "reverb_unit.hpp"

using namespace Mikami;

const int FS_ = 12000;      // Sampling frequency: 12 kHz
ADC_BuiltIn adc_(A0, FS_);  // for AD
DAC_MCP4921 myDac_;         // for DA

const float G_C_ = 0.8f;
const float G_A_ = 0.6f;
const float G0_ = 1.0f - G_C_;
CombFilter<887>    cm1(G_C_);
CombFilter<1153>   cm2(G_C_);
CombFilter<1499>   cm3(G_C_);
AllpassFilter<97>  ap1(G_A_);
AllpassFilter<131> ap2(G_A_);

DigitalIn sw_(D2, PullDown);

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    while (true)
    {
        float xn = adc_.Read(); // Read from A0
        //-----------------------------------------------

        xn = G0_*xn;
        // parallel part using comb filters
        float yn = cm1.Execute(xn) + cm2.Execute(xn)
                 + cm3.Execute(xn);
        // cascade part using allpass filters
        yn = ap2.Execute(ap1.Execute(yn));
        // add direct input signal
        yn = yn + xn;

        if (sw_.read() == 0) yn = xn;   // no reverb

        //-----------------------------------------------
        myDac_.Write(yn);       // Write to DAC
    }
}
