//--------------------------------------------------------------
// Comb filter
// 2014/10/23, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef COMB_FILTER_HPP
#define COMB_FILTER_HPP

#include "mbed.h"

template<int delay> class CombFilter
{
private:
    const float GC_;
    int ptr_;
    float un_[delay];    // for delay
    float Get() { return un_[ptr_]; }
    void Set(float x)
    {
        un_[ptr_] = x;   
        if (++ptr_ >=  delay) ptr_ = 0;
    }
public:
    // Constructor
    CombFilter(float g) : GC_(g), ptr_(0) {}

    // Execute comb filter 
    float Execute(float x)
    {
        float yn = Get();
        Set(x + GC_*yn);
        return yn;
     }

    // Clear internal delay elements
    void Clear()
    { for (int n=0; n<delay; n++) un_[n] = 0; }
};
#endif  // COMB_FILTER_HPP

