//--------------------------------------------------------------
// Reverb system using all-pass filter dlass
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

#include "allpass_filter.hpp"

using namespace Mikami;

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

const float G_A_ = 0.6f;
AllpassFilter<1153> allpass_(G_A_);

DigitalIn sw_(D2, PullDown);

int main()
{  
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz
    while (true)
    {
        float xn = adc_.Read(); // Read from A0
        //-----------------------------------------------

        float yn;
        if (sw_.read() == 1) yn = allpass_.Execute(xn);
        else                 yn = xn;

        //-----------------------------------------------
        myDac_.Write(yn);       // Write to DAC
    }
}
