//--------------------------------------------------------------
// All-pass filter
// 2014/10/23, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef ALLPASS_FILTER_HPP
#define ALLPASS_FILTER_HPP

#include "mbed.h"

template<int delay> class AllpassFilter
{
private:
    const float G0_;
    int ptr_;
    float un_[delay];    // for delay
    float Get() { return un_[ptr_]; }
    void Set(float x)
    {
        un_[ptr_] = x;   
        if (++ptr_ >=  delay) ptr_ = 0;
    }
public:
    // Constructor
    AllpassFilter(float g) : G0_(g), ptr_(0) {}

    // Execute comb filter 
    float Execute(float x)
    {
        float un = x + G0_*Get();
        float yn = -G0_*un + Get();
        Set(un);
        return yn;
     }

    // Clear internal delay elements
    void Clear()
    { for (int n=0; n<delay; n++) un_[n] = 0; }
};
#endif  // ALLPASS_FILTER_HPP


