//--------------------------------------------------------------
// 移動平均, 平均数：1, 2, 4, 8, 16, 32, 64：スイッチで選択
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2014/11/12, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

DigitalIn sw1_(D2, PullDown);
DigitalIn sw2_(D3, PullDown);
DigitalIn sw4_(D4, PullDown);
DigitalIn sw8_(D5, PullDown);

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    const int M = 64;
    
    float xn[M];
    for (int n=0; n<M; n++) xn[n] = 0;
    
    while (true)
    {
        int sw = (sw8_ << 3) | (sw4_ << 2) | (sw2_ << 1) | sw1_;
        int nAv = 1 << sw;
        if (nAv > 64) nAv = 64;
        
        xn[0] = adc_.Read();    // Read from A0
        //-----------------------------------------------

        float yn = 0;
        for (int k=0; k<nAv; k++) yn = yn + xn[k];
        yn = yn/(float)nAv;     // yn: average
        
        // Update input buffer
        for (int k = nAv-1; k>0; k--)
            xn[k] = xn[k-1];

        //-----------------------------------------------
        myDac_.Write(yn);   // Write to DAC
    }
}
