//--------------------------------------------------------------
//  移動平均, 平均数：1, 2, 4, 8, 16, 32, 64：スイッチで選択
//  平均するデータ数，スイッチの状態を LCD 表示器に表示する
//
//      Analog Input : A0
//      Analog Output: MCP4921 or 4922 using SPI
// 2015/07/25, Copyright (c) 2015 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Interrupt.hpp"    // for ADC using interrupt
#include "DAC_MCP4921.hpp"      // for DAC MCP4921, MCP4922

using namespace Mikami;

// ACM1602Ni を使う場合は次の define 文をコメントにすること
#define AQM1602

#ifdef AQM1602
#include "AQM1602.hpp"
Aqm1602 Lcd_;
#else
#include "ACM1602NI.hpp"
Acm1602Ni Lcd_;
#endif

const int FS_ = 12000;      // Sampling frequency: 12 kHz
ADC_Intr adc_(A0, FS_);     // for AD using interrupt
DAC_MCP4921 myDac_;         // for DA

BusIn sw_(D2, D3, D4, D5);  // for switch

const int M_ = 64;  // Maximum of average count
float xn_[M_];
volatile int nAv_;  // "volatile": to make sure

// Interrupt service routine for ADC
void AdcIsr()
{   
    xn_[0] = adc_.Read();   // Read from A0
    //-----------------------------------------------

    float yn = 0;
    for (int k=0; k<nAv_; k++) yn = yn + xn_[k];
    yn = yn/(float)nAv_;    // yn: average

    // Update input buffer
    for (int k = nAv_-1; k>0; k--)
        xn_[k] = xn_[k-1];

    //-----------------------------------------------
    myDac_.Write(yn);       // Write to DAC
}

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz
    sw_.mode(PullDown);
    Lcd_.Clear();
    adc_.SetIntrVec(AdcIsr);        // Assign ISR for ADC interrupt

    for (int n=0; n<M_; n++) xn_[n] = 0;
    
    while (true)
    {
        int sw = sw_.read();
        nAv_ = 1 << sw;
        if (nAv_ > 64) nAv_ = 64;       
        printf("\r\nnAv = %d, sw = %d", nAv_, sw);
        char str[17];
        sprintf(str, "nAv : %2d", nAv_);
        Lcd_.WriteStringXY(str, 0, 0);
        sprintf(str, "sw  : %2d", sw);
        Lcd_.WriteStringXY(str, 0, 1);

        wait(0.5f);
    }
}
