//--------------------------------------------------------------
// 入力の切り替え（ラインとマイク），LCD 表示 ---- 割り込み利用
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2014/12/26, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "ADC_Interrupt.hpp"    // for ADC using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922
#include "ACM1602NI.hpp"        // for LCD

using namespace Mikami;

const int FS_ = 10000;          // Sampling frequency: 10 kHz
ADC_Intr adc_(A0, FS_, A1);     // CH1: Line, CH2: Mic
DAC_MCP4922 myDac_;             // for DA
DigitalIn sw_(D2, PullDown);    // for SW
Acm1602Ni lcd_;                 // for LCD

// Interrupt service routine for ADC
void AdcIsr()
{   
    float xn = adc_.Read(); // Read from A0
    myDac_.Write(xn);       // to DAC
}

int main()
{
    lcd_.Clear();
    myDac_.ScfClockTim3(420000);    // cutoff frequency: 4.2 kHz
    adc_.SetIntrVec(AdcIsr);        // Assign ISR for ADC interrupt

    int swBefore = 0;

    while (true)
    {
        int swNow = sw_.read();
        if (swNow != swBefore)
        {
            if (swNow == 0) adc_.Select1stChannel(); // line input
            else            adc_.Select2ndChannel(); // mic. input
            swBefore = swNow;
        }   

        if (swNow == 0) lcd_.WriteStringXY("Input: Line", 0, 0);
        else            lcd_.WriteStringXY("Input: Mic ", 0, 0);
        wait(0.1f);
    }
}
