//--------------------------------------------------------------
// IIR フィルタ，直接形，double で演算
//      Analog Input : A0
//      Analog Output: MCP4922 using SPI
// 2014/11/20, Copyright (c) 2014 MIKAMI, Naoki
//--------------------------------------------------------------

#include "mbed.h"

#include "ADC_Base.hpp"         // for ADC not using interrupt
#include "DAC_MCP4922.hpp"      // for DAC MCP4922

using namespace Mikami;

const int ORDER_ = 6;   // order
// 低域通過フィルタ
// 連立チェビシェフ特性
// 次数　　　　：6 次
// 標本化周波数： 12.00 kHz
// 遮断周波数　：  0.40 kHz
// 通過域のリップル： 0.50 dB
// 阻止域の減衰量　：40.00 dB
const double am_[ORDER_] = {
      5.684787115202E+00, -1.354501388127E+01,  1.731054054746E+01,
     -1.251297336508E+01,  4.850124049778E+00, -7.874837248679E-01};
const double bm_[ORDER_+1] = {
      1.000028097647E-02, -5.466081078904E-02,  1.292315717890E-01,
     -1.691239024945E-01,  1.292315717890E-01, -5.466081078904E-02,
      1.000028097647E-02};

const int FS_ = 12000;  // Sampling frequency: 12 kHz
ADC_Base adc_(A0, FS_); // for AD
DAC_MCP4922 myDac_;     // for DA

int main()
{
    myDac_.ScfClockTim3(500000);    // cutoff frequency: 5 kHz

    double un[ORDER_+1];            // Buffer corresponding to delays
    for (int k=0; k<=ORDER_; k++) un[k] = 0; 

    while (true)
    {
        float xn = adc_.Read();     // Read from A0
        //-----------------------------------------------

        un[0] = xn;
        for (int k=0; k<ORDER_; k++) un[0] = un[0] + am_[k]*un[k+1];
        double yn = 0;
        for (int k=0; k<=ORDER_; k++) yn = yn + bm_[k]*un[k];

        // 計算結果の移動
        for (int k=ORDER_; k>0; k--) un[k] = un[k-1];

        //-----------------------------------------------
        myDac_.Write((float)yn);    // Write to DAC
    }
}

